[ env.ini ]
set var=CONF_REGION value="tr(1,World)"
set var=CONF_PROVIDER value="tr(2,Expert)"
set var=CONF_DESCRIPTION value="tr(3,Routed PPPoE Packet Service configuration with backup.)"
set var=CONF_SERVICE value="tr(4,Routed PPPoE - Backup)"
set var=CONF_DATE value=""
set var=CONF_TPVERSION value=1.2.0
set var=HOST_SETUP value=auto
set var=UPGRADE_URL value=http://www.speedtouch.com/upgrade500.htm
set var=ATM_addr value="8.35"
set var=ATM_auto value=active
set var=BAK_ip value=""
set var=BAK_dns value=""

[ wizard.ini ]
' ATM=PVC
'--------
def var=ATM type=grp desc="tr(5,Specify the details of the Routed PPPoE Packet Service. All information should be provided by your ISP.)" alias="tr(6,Routed PPPoE Packet Service)"
def var=ATM_addr type=combo grp=ATM alias="VPI/VCI" data="0.32,0.33,0.35,0.36,0.37,0.38,0.100,1.32,1.33,1.100,8.35,8.36,8.37,8.48,8.81" desc="tr(7,Choose a VPI/VCI from the list)"
def var=ATM_auto type=bool grp=ATM alias="tr(8,Auto-configured)" data="passive,active"
' PPP=Settings
'-------------
def var=PPP type=grp desc="tr(9,Specify the details of the Routed PPP Account. All information should be provided by your ISP.)" alias="tr(10,PPP Account Settings)"
def var=PPP_user type=string grp=PPP alias="tr(11,User Name)" req=yes desc="tr(12,Enter your Internet connection user name.)"
def var=%PPP_pwd type=passw grp=PPP alias="tr(13,Password)" req=yes desc="tr(14,Enter your Internet connection password.)" max=32
def var=PPP_ac type=string grp=PPP alias="tr(15,Access Concentrator)" req=no desc="tr(16,Enter the PPPoE Access Concentrator Name.)"
def var=PPP_service type=string grp=PPP alias="tr(17,Service Name)" req=no desc="tr(18,Enter the PPPoE Service Name.)"
' Backup=Settings
'----------------
def var=BAK type=grp desc="tr(19,Specify the IP details of the backup connection.)" alias="tr(20,Backup Connection Settings)"
def var=BAK_ip type=ipaddr grp=BAK alias="tr(21,Backup Router)" req=yes desc="tr(22,Enter the IP address of the backup router.)"
def var=BAK_dns type=ipaddr grp=BAK alias="tr(23,DNS Server)" req=yes desc="tr(24,Enter the IP address of the DNS server.)"
'ST Security
'-----------
def var=ST type=grp desc="tr(25,Specify user name and password to protect SpeedTouch administrative access.)" alias="tr(26,SpeedTouch Security)"
def var=%ST_SYS_USERNAME type=string grp=ST alias="tr(27,User Name)" desc="tr(28,Enter user name.)"
def var=%ST_SYS_PASSWORD type=passw grp=ST alias="tr(29,Password)" desc="tr(30,Enter your password.)" max=32
def var=dummy type=passwcheck grp=ST alias="tr(31,Confirm Password)" desc="tr(32,Re-enter your password)" linkvar=%ST_SYS_PASSWORD max=32

[ hostwizard.ini ]

[ phone.ini ]
add name=USB addr=usb.0.35 type=any logging=off
add name=PVC_1 addr=$ATM_addr type=any

[ bridge.ini ]
ifadd intf=USB dest=USB logging=off
ifattach intf=USB logging=off
config age=300 filter=no_WAN_broadcast

[ pptp.ini ]

[ dhcp.ini ]
config autodhcp=on scantime=10 state=enabled trace=off
policy verifyfirst=on trustclient=on
pool add name=LAN_private
pool config name=LAN_private poolstart=10.0.0.1 poolend=10.0.0.254 netmask=255.255.255.0 gateway=10.0.0.138 leasetime=7200

[ ethoa.ini ]
ifadd intf=ETHoA_1 dest=PVC_1
ifattach intf=ETHoA_1

[ ipoa.ini ]

[ pppoa.ini ]

[ pppoe.ini ]
ifadd intf=PPPoE_1
rtadd intf=PPPoE_1 dst=0.0.0.0/0 src=0.0.0.0/0
ifconfig intf=PPPoE_1 dest=RELAY user=$PPP_user password=$%PPP_pwd acname=$PPP_ac servicename=$PPP_service accomp=on addrtrans=pat restart=on
ifattach intf=PPPoE_1

[ pppoerelay.ini ]
add port=ETHoA_1
add port=eth0

[ cip.ini ]

[ ip.ini ]
config forwarding=on firewalling=on redirects=on sourcerouting=off netbroadcasts=off ttl=64 fraglimit=64 defragmode=always addrcheck=dynamic mssclamping=on
apadd addr=10.0.0.138/24 intf=eth0 addroute=yes type=1
ifconfig intf=loop mtu=1500 group=local linksensing=off
ifconfig intf=eth0 mtu=1500 group=lan linksensing=off
rtadd dst=255.255.255.255/32 gateway=10.0.0.138
rtadd dst=224.0.0.0/4 intf=eth0
rtadd dst=$BAK_dns dstmsk=255.255.255.255 intf=PPPoE_1
rtadd dst=0.0.0.0/0 gateway=$BAK_ip metric=10

[ dnsd.ini ]
domain domain=lan
add hostname=SpeedTouch
fwdadd dns=$BAK_dns src=0.0.0.0/0 direct=no
fwdadd dns=$BAK_ip src=0.0.0.0/0 direct=no
start
troff

[ dhcr.ini ]
ifconfig intf=eth0 relay=on
add addr=127.0.0.1 intf=eth0 giaddr=10.0.0.138

[ autopvc.ini ]
#if $ATM_auto=active
config mode=active type=pppoerelay overwrite=enabled peakrate=0
#else
config mode=passive type=bridge
#endif

[ system.ini ]
config upnp=enabled mdap=enabled dcache=enabled drst=enabled
#if $%ST_SYS_PASSWORD=""
setpassword password="" userid=$%ST_SYS_USERNAME
#else
setpassword password=$%ST_SYS_PASSWORD userid=$%ST_SYS_USERNAME
#endif

[ upnp.ini ]
config defcservice=PPPoE_1

[ language.ini ]
langdef lang=nl charset=ISO-8859-1
t r="1, Wereld"
t r="2, Expert"
t r="3, Configuratie met routed-PPPoE Packet-service en reserveverbinding."
t r="4, Routed PPPoE - reserveverbinding"
t r="5, Geef de details van de routed-PPPoE Packet-service op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="6, Routed-PPPoE Packet-service"
t r="7, Selecteer een VPI/VCI uit de lijst"
t r="8, Automatische configuratie"
t r="9, Geef de details van de routed-PPP-account op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="10, Instellingen van PPP-account"
t r="11, Gebruikersnaam"
t r="12, Geef de gebruikersnaam voor uw Internet-verbinding in."
t r="13, Wachtwoord"
t r="14, Geef het wachtwoord voor uw Internet-verbinding in."
t r="15, Access Concentrator"
t r="16, Geef de naam van de PPPoE Access Concentrator in."
t r="17, Naam van service"
t r="18, Geef de naam van de PPPoE-service in."
t r="19, Geef de IP-gegevens van de reserveverbinding op."
t r="20, Instellingen van reserveverbinding"
t r="21, Reserverouter"
t r="22, Geef het IP-adres van de reserverouter in."
t r="23, DNS-server"
t r="24, Geef het IP-adres van de DNS-server in."
t r="25, Geef de gebruikersnaam en het wachtwoord op waarmee u het beheer van de SpeedTouch wilt beveiligen."
t r="26, SpeedTouch-beveiliging"
t r="27, Gebruikersnaam"
t r="28, Geef uw gebruikersnaam in."
t r="29, Wachtwoord"
t r="30, Geef uw wachtwoord in."
t r="31, Wachtwoord bevestigen"
t r="32, Geef uw wachtwoord nogmaals in."
langdef lang=fr charset=ISO-8859-1
t r="1, Monde"
t r="2, Expert"
t r="3, Configuration du service de transmission par paquets PPPoE rout avec connexion de secours."
t r="4, PPPoE rout et connexion de secours"
t r="5, Spcifiez les dtails relatifs au service de transmission par paquets PPPoE rout. Toutes ces informations doivent tre fournies par votre FAI."
t r="6, Service de transmission par paquets PPPoE rout"
t r="7, Slectionnez un VPI/VCI dans la liste"
t r="8, Auto-configur"
t r="9, Spcifiez les dtails relatifs au compte de la connexion PPP rout. Toutes ces informations doivent tre fournies par votre FAI."
t r="10, Paramtres du compte PPP"
t r="11, Nom d'utilisateur"
t r="12, Entrez le nom d'utilisateur employ pour votre connexion  Internet."
t r="13, Mot de passe"
t r="14, Entrez le mot de passe employ pour votre connexion  Internet."
t r="15, Concentrateur d'accs"
t r="16, Entrez le nom du concentrateur d'accs PPPoE."
t r="17, Nom du service"
t r="18, Entrez le nom du service PPPoE."
t r="19, Spcifiez les informations IP de la connexion de secours."
t r="20, Paramtres de la connexion de secours"
t r="21, Routeur de secours"
t r="22, Entrez l'adresse IP du routeur de secours."
t r="23, Serveur DNS"
t r="24, Entrez l'adresse IP du serveur DNS."
t r="25, Indiquez un nom d'utilisateur et un mot de passe pour protger l'accs administratif de SpeedTouch."
t r="26, Scurit SpeedTouch"
t r="27, Nom d'utilisateur"
t r="28, Entrez un nom d'utilisateur."
t r="29, Mot de passe"
t r="30, Entrez votre mot de passe."
t r="31, Confirmer le mot de passe"
t r="32, Entrez  nouveau le mot de passe"
langdef lang=de charset=ISO-8859-1
t r="1, Welt"
t r="2, Expert"
t r="3, Konfiguration des Routed PPPoE-Paketdienstes mit Backup."
t r="4, Routed PPPoE - Backup"
t r="5, Geben Sie die Einzelheiten zum Routed PPPoE-Paketdienst an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="6, Routed PPPoE-Paketdienst"
t r="7, Whlen Sie einen VPI/VCI-Eintrag aus der Liste aus"
t r="8, Automatisch konfiguriert"
t r="9, Geben Sie die Einzelheiten zum Routed PPP-Konto an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="10, Einstellungen fr das PPP-Konto"
t r="11, Benutzername"
t r="12, Geben Sie den Benutzernamen fr die Internetverbindung ein."
t r="13, Kennwort"
t r="14, Geben Sie das Kennwort fr die Internetverbindung ein."
t r="15, Zugangskonzentrator"
t r="16, Geben Sie den Namen des PPPoE-Zugangskonzentrators ein."
t r="17, Dienstname"
t r="18, Geben Sie den Namen des PPPoE-Dienstes ein."
t r="19, Geben Sie die IP-Informationen fr die Backupverbindung an."
t r="20, Einstellungen fr die Backupverbindung"
t r="21, Backuprouter"
t r="22, Geben Sie die IP-Adresse des Backuprouters ein."
t r="23, DNS-Server"
t r="24, Geben Sie die IP-Adresse des DNS-Servers ein."
t r="25, Geben Sie den Benutzernamen und das Kennwort an, um den Administratorzugriff auf das SpeedTouch zu schtzen."
t r="26, SpeedTouch Sicherheit"
t r="27, Benutzername"
t r="28, Geben Sie den Benutzernamen ein."
t r="29, Kennwort"
t r="30, Geben Sie das Kennwort ein."
t r="31, Kennwort besttigen"
t r="32, Geben Sie das Kennwort erneut ein."
langdef lang=it charset=ISO-8859-1
t r="1, Mondo"
t r="2, Esperta"
t r="3, Configurazione per la trasmissione di pacchetti in modalit routed PPPoE con backup."
t r="4, Routed PPPoE - Backup"
t r="5, Specificare i dettagli per la trasmissione di pacchetti in modalit routed PPPoE. Tutte le informazioni devono essere fornite dall'ISP."
t r="6, Trasmissione di pacchetti in modalit routed PPPoE"
t r="7, Scegliere un VPI/VCI dall'elenco"
t r="8, Autoconfigurato"
t r="9, Specificare i dettagli dell'account routed PPP. Tutte le informazioni devono essere fornite dall'ISP."
t r="10, Impostazioni account PPP"
t r="11, Nome utente"
t r="12, Immettere il nome utente di connessione a Internet."
t r="13, Password"
t r="14, Immettere la password di connessione a Internet."
t r="15, Concentratore di accessi"
t r="16, Immettere il nome del concentratore di accesso PPPoE."
t r="17, Nome servizio"
t r="18, Immettere il nome del servizio PPPoE."
t r="19, Specificare i dettagli IP della connessione di backup."
t r="20, Impostazioni connessione di backup"
t r="21, Router di backup"
t r="22, Immettere l'indirizzo IP del router di backup."
t r="23, Server DNS"
t r="24, Immettere l'indirizzo IP del server DNS."
t r="25, Specificare un nome utente e una password per proteggere l'accesso amministrativo dello SpeedTouch."
t r="26, Sicurezza SpeedTouch"
t r="27, Nome utente"
t r="28, Immettere il nome utente."
t r="29, Password"
t r="30, Immettere la password."
t r="31, Conferma password"
t r="32, Immettere nuovamente la password."
langdef lang=pt charset=ISO-8859-1
t r="1, Mundo"
t r="2, Avanado"
t r="3, Configurao do Servio de Pacote do PPPoE Roteado com backup."
t r="4, PPPoE roteado - Backup"
t r="5, Especifique os detalhes do Servio de Pacote do PPPoE Roteado. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="6, Servio de Pacote do PPPoE Roteado"
t r="7, Escolha um VPI/VCI na lista"
t r="8, Auto configurado"
t r="9, Especifique os detalhes da Conta do PPP Roteado. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="10, Configuraes da Conta do PPP"
t r="11, Nome do usurio"
t r="12, Digite seu nome do usurio de conexo com a Internet."
t r="13, Senha"
t r="14, Digite sua senha de conexo com a Internet."
t r="15, Centralizador de acesso"
t r="16, Insira o nome do centralizador de acesso do PPPoE."
t r="17, Nome do servio"
t r="18, Insira o nome do servio do PPPoE."
t r="19, Especifique os detalhes IP da conexo de backup."
t r="20, Configuraes da conexo de backup"
t r="21, Roteador de backup"
t r="22, Insira o endereo IP do roteador de backup."
t r="23, Servidor DNS"
t r="24, Insira o endereo IP do servidor DNS."
t r="25, Especifique o nome do usurio e a senha para proteger o acesso administrativo do SpeedTouch."
t r="26, Segurana do SpeedTouch"
t r="27, Nome do usurio"
t r="28, Digite o nome do usurio."
t r="29, Senha"
t r="30, Digite sua senha."
t r="31, Confirme a senha"
t r="32, Digite novamente sua senha"
langdef lang=es charset=ISO-8859-1
t r="1, Mundial"
t r="2, Experto"
t r="3, Configuracin de servicios de paquetes PPPoE enrutados con copia de seguridad."
t r="4, PPPoE enrutados; copia de seguridad"
t r="5, Indique los detalles del servicio de paquetes PPPoE enrutados. Toda la informacin debe proporcionarla el ISP."
t r="6, Servicio de paquetes PPPoE enrutados"
t r="7, Elija un identificador VPI/VCI de la lista"
t r="8, Configurado automticamente"
t r="9, Indique los detalles de la cuenta PPP enrutada. Toda la informacin debe proporcionarla el ISP."
t r="10, Configuracin de cuentas PPP"
t r="11, Nombre de usuario"
t r="12, Escriba el nombre de usuario de conexin a Internet."
t r="13, Contrasea"
t r="14, Escriba la contrasea de conexin a Internet."
t r="15, Concentrador de acceso"
t r="16, Escriba el nombre del concentrador de acceso a PPPoE."
t r="17, Nombre del servicio"
t r="18, Escriba el nombre del servicio PPPoE."
t r="19, Indique los detalles de IP de la conexin de copia de seguridad."
t r="20, Configuracin de la conexin de copia de seguridad"
t r="21, Enrutador de copia de seguridad"
t r="22, Escriba la direccin IP del enrutador de copia de seguridad."
t r="23, Servidor DNS"
t r="24, Escriba la direccin IP del servidor DNS."
t r="25, Indique el nombre de usuario y la contrasea para proteger el acceso administrativo a SpeedTouch."
t r="26, Seguridad de SpeedTouch"
t r="27, Nombre de usuario"
t r="28, Escriba el nombre de usuario."
t r="29, Contrasea"
t r="30, Escriba la contrasea."
t r="31, Confirme la contrasea"
t r="32, Vuelva a escribir la contrasea"
langdef lang=sv charset=ISO-8859-1
t r="1, Vrld"
t r="2, Expert"
t r="3, Konfiguration fr Routed PPPoE Packet Service med backup."
t r="4, Routed PPPoE - Backup"
t r="5, Ange information om Routed PPPoE Packet Service. Din ISP ska kunna ge all information."
t r="6, Routed PPPoE Packet Service"
t r="7, Vlj VPI/VCI frn listan"
t r="8, Autokonfigurerad"
t r="9, Ange information om kontot fr Routed PPP. Din ISP ska kunna ge all information."
t r="10, Kontoinstllningar fr PPP"
t r="11, Anvndarnamn"
t r="12, Ange anvndarnamn fr din Internet-anslutning."
t r="13, Lsenord"
t r="14, Ange lsenord fr din Internet-anslutning."
t r="15, tkomstkoncentrator"
t r="16, Ange namnet p PPPoE tkomstkoncentrator (Access Concentrator)."
t r="17, Tjnstnamn"
t r="18, Ange namnet p PPPoE-tjnsten."
t r="19, Ange IP-information fr backup-anslutningen."
t r="20, Instllningar fr backup-anslutningen"
t r="21, Backup-router"
t r="22, Ange IP-adress fr backup-routern."
t r="23, DNS-server"
t r="24, Ange IP-adress fr DNS-servern."
t r="25, Ange anvndarnamn och lsenord fr att skydda administrativ tkomst till SpeedTouch."
t r="26, SpeedTouch-skerhet"
t r="27, Anvndarnamn"
t r="28, Ange anvndarnamn."
t r="29, Lsenord"
t r="30, Ange lsenord."
t r="31, Bekrfta lsenord"
t r="32, Ange ditt lsenord igen"

[ endofarch ]
